﻿/*	VERSION:	1.0

DESCRIPTION:
	This takes a path as a string,  and returns the container & variable name.  (container is an object reference)
	Output has 2 things:
	- container:	Reference to the object specified in the path
	- name:				Name of the variable at the end of the path

USAGE:
	#include "functions/getContainer.as"
	var info = getContainer( myPath );
	info.container[info.name] = newValue;
	
OUTPUT:
	{container, name}
	container		Reference to the container, minus the variable name at the end.
	name				String:  variable name at the end of the path.

INPUT:
	RAM.myObject.object2.varName
	(starts with a global variable)
	
	
BEHAVIOR:
	Input:		"myVar"
	output:		container: Reference to the default container  (RAM)
						name: "myVar"
						
	Input:		undefined
	output:		container: undefined
						name: undefined
						
	Input:		"myObj.myVar"
	output:		container: Ref to RAM.myObj
						name: "myVar"
	
	Input:		"myObj3.myVar"		(if RAM.myObj3 doesn't exist,  or if RAM doesn't exist)
	output:		container: undefined
						name: "myVar"
						
	Input:		"myObj1.invalidObj.myVar"		(if invalidObj doesn't exist within myObj1)
	output:		container: undefined
						name: "myVar"
	
	Input:		"myObj."
	output:		container: Reference to RAM.myObj
						name: ""
	
	Input:		""
	output:		container: undefined
						name: undefined
	
	Input:		"."
	output:		container: undefined
						name: ""
*/
#include "getPathValue.as"
getContainer = function( target, defaultContainer, defaultContainerName ){
	var defContainerObj, defContainerName;
	var divideAt = null;
	var varContainer, varContainerName, varName;
	var output = null;
	
	defContainerObj = defaultContainer || _global.RAM;
	defContainerName = defaultContainerName || "RAM";
	if(target){
		// resolve target variable
		divideAt = target.lastIndexOf(".");
		if(divideAt==-1){
			if(target==defContainerName){		// if:  accidentally attempting to target "RAM"  (which wouldn't work anyway)
				varContainer = null;			// don't affect anything
			}else{
				varContainerName = defContainerName;
				varContainer = defContainerObj;
			}
		}else{
			varContainerName = target.substr(0,divideAt);
			varContainer = getPathValue( varContainerName, defContainerName );
		}// if:  . was found
		varName = target.substr(divideAt+1);
		
		output = {
			container: varContainer,
			name: varName
		}
		return output;
		//RAM[target] = newName;
	}// if:  target specified
}// getContainer()